<?php
/**
 * The template to display the widgets area in the header
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0
 */

// Header sidebar
$takeout_header_name    = takeout_get_theme_option( 'header_widgets' );
$takeout_header_present = ! takeout_is_off( $takeout_header_name ) && is_active_sidebar( $takeout_header_name );
if ( $takeout_header_present ) {
	takeout_storage_set( 'current_sidebar', 'header' );
	$takeout_header_wide = takeout_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $takeout_header_name ) ) {
		dynamic_sidebar( $takeout_header_name );
	}
	$takeout_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $takeout_widgets_output ) ) {
		$takeout_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $takeout_widgets_output );
		$takeout_need_columns   = strpos( $takeout_widgets_output, 'columns_wrap' ) === false;
		if ( $takeout_need_columns ) {
			$takeout_columns = max( 0, (int) takeout_get_theme_option( 'header_columns' ) );
			if ( 0 == $takeout_columns ) {
				$takeout_columns = min( 6, max( 1, takeout_tags_count( $takeout_widgets_output, 'aside' ) ) );
			}
			if ( $takeout_columns > 1 ) {
				$takeout_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $takeout_columns ) . ' widget', $takeout_widgets_output );
			} else {
				$takeout_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $takeout_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'takeout_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $takeout_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $takeout_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'takeout_action_before_sidebar', 'header' );
				takeout_show_layout( $takeout_widgets_output );
				do_action( 'takeout_action_after_sidebar', 'header' );
				if ( $takeout_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $takeout_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'takeout_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
