<?php
/**
 * The template to display default site footer
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0.10
 */

$takeout_footer_id = takeout_get_custom_footer_id();
$takeout_footer_meta = get_post_meta( $takeout_footer_id, 'trx_addons_options', true );
if ( ! empty( $takeout_footer_meta['margin'] ) ) {
	takeout_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( takeout_prepare_css_value( $takeout_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $takeout_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $takeout_footer_id ) ) ); ?>
						<?php
						$takeout_footer_scheme = takeout_get_theme_option( 'footer_scheme' );
						if ( ! empty( $takeout_footer_scheme ) && ! takeout_is_inherit( $takeout_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $takeout_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'takeout_action_show_layout', $takeout_footer_id );
	?>
</footer><!-- /.footer_wrap -->
