<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$takeout_copyright_scheme = takeout_get_theme_option( 'copyright_scheme' );
if ( ! empty( $takeout_copyright_scheme ) && ! takeout_is_inherit( $takeout_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $takeout_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$takeout_copyright = takeout_get_theme_option( 'copyright' );
			if ( ! empty( $takeout_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$takeout_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $takeout_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$takeout_copyright = takeout_prepare_macros( $takeout_copyright );
				// Display copyright
				echo wp_kses( nl2br( $takeout_copyright ), 'takeout_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
