<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0
 */

$takeout_template_args = get_query_var( 'takeout_template_args' );
if ( is_array( $takeout_template_args ) ) {
	$takeout_columns    = empty( $takeout_template_args['columns'] ) ? 2 : max( 1, $takeout_template_args['columns'] );
	$takeout_blog_style = array( $takeout_template_args['type'], $takeout_columns );
    $takeout_columns_class = takeout_get_column_class( 1, $takeout_columns, ! empty( $takeout_template_args['columns_tablet']) ? $takeout_template_args['columns_tablet'] : '', ! empty($takeout_template_args['columns_mobile']) ? $takeout_template_args['columns_mobile'] : '' );
} else {
	$takeout_template_args = array();
	$takeout_blog_style = explode( '_', takeout_get_theme_option( 'blog_style' ) );
	$takeout_columns    = empty( $takeout_blog_style[1] ) ? 2 : max( 1, $takeout_blog_style[1] );
    $takeout_columns_class = takeout_get_column_class( 1, $takeout_columns );
}

$takeout_post_format = get_post_format();
$takeout_post_format = empty( $takeout_post_format ) ? 'standard' : str_replace( 'post-format-', '', $takeout_post_format );

?><div class="
<?php
if ( ! empty( $takeout_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( takeout_is_blog_style_use_masonry( $takeout_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $takeout_columns ) : esc_attr( $takeout_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $takeout_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $takeout_columns )
		. ( 'portfolio' != $takeout_blog_style[0] ? ' ' . esc_attr( $takeout_blog_style[0] )  . '_' . esc_attr( $takeout_columns ) : '' )
	);
	takeout_add_blog_animation( $takeout_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$takeout_hover   = ! empty( $takeout_template_args['hover'] ) && ! takeout_is_inherit( $takeout_template_args['hover'] )
								? $takeout_template_args['hover']
								: takeout_get_theme_option( 'image_hover' );

	if ( 'dots' == $takeout_hover ) {
		$takeout_post_link = empty( $takeout_template_args['no_links'] )
								? ( ! empty( $takeout_template_args['link'] )
									? $takeout_template_args['link']
									: get_permalink()
									)
								: '';
		$takeout_target    = ! empty( $takeout_post_link ) && takeout_is_external_url( $takeout_post_link )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$takeout_components = ! empty( $takeout_template_args['meta_parts'] )
							? ( is_array( $takeout_template_args['meta_parts'] )
								? $takeout_template_args['meta_parts']
								: explode( ',', $takeout_template_args['meta_parts'] )
								)
							: takeout_array_get_keys_by_value( takeout_get_theme_option( 'meta_parts' ) );

	// Featured image
	takeout_show_post_featured( apply_filters( 'takeout_filter_args_featured',
        array(
			'hover'         => $takeout_hover,
			'no_links'      => ! empty( $takeout_template_args['no_links'] ),
			'thumb_size'    => ! empty( $takeout_template_args['thumb_size'] )
								? $takeout_template_args['thumb_size']
								: takeout_get_thumb_size(
									takeout_is_blog_style_use_masonry( $takeout_blog_style[0] )
										? (	strpos( takeout_get_theme_option( 'body_style' ), 'full' ) !== false || $takeout_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( takeout_get_theme_option( 'body_style' ), 'full' ) !== false || $takeout_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => takeout_is_blog_style_use_masonry( $takeout_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $takeout_components,
			'class'         => 'dots' == $takeout_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $takeout_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $takeout_post_link )
												? '<a href="' . esc_url( $takeout_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $takeout_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $takeout_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $takeout_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!