<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0.50
 */

$takeout_template_args = get_query_var( 'takeout_template_args' );
if ( is_array( $takeout_template_args ) ) {
	$takeout_columns    = empty( $takeout_template_args['columns'] ) ? 2 : max( 1, $takeout_template_args['columns'] );
	$takeout_blog_style = array( $takeout_template_args['type'], $takeout_columns );
} else {
	$takeout_template_args = array();
	$takeout_blog_style = explode( '_', takeout_get_theme_option( 'blog_style' ) );
	$takeout_columns    = empty( $takeout_blog_style[1] ) ? 2 : max( 1, $takeout_blog_style[1] );
}
$takeout_blog_id       = takeout_get_custom_blog_id( join( '_', $takeout_blog_style ) );
$takeout_blog_style[0] = str_replace( 'blog-custom-', '', $takeout_blog_style[0] );
$takeout_expanded      = ! takeout_sidebar_present() && takeout_get_theme_option( 'expand_content' ) == 'expand';
$takeout_components    = ! empty( $takeout_template_args['meta_parts'] )
							? ( is_array( $takeout_template_args['meta_parts'] )
								? join( ',', $takeout_template_args['meta_parts'] )
								: $takeout_template_args['meta_parts']
								)
							: takeout_array_get_keys_by_value( takeout_get_theme_option( 'meta_parts' ) );
$takeout_post_format   = get_post_format();
$takeout_post_format   = empty( $takeout_post_format ) ? 'standard' : str_replace( 'post-format-', '', $takeout_post_format );

$takeout_blog_meta     = takeout_get_custom_layout_meta( $takeout_blog_id );
$takeout_custom_style  = ! empty( $takeout_blog_meta['scripts_required'] ) ? $takeout_blog_meta['scripts_required'] : 'none';

if ( ! empty( $takeout_template_args['slider'] ) || $takeout_columns > 1 || ! takeout_is_off( $takeout_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $takeout_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( takeout_is_off( $takeout_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $takeout_custom_style ) ) . "-1_{$takeout_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $takeout_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $takeout_columns )
					. ' post_layout_' . esc_attr( $takeout_blog_style[0] )
					. ' post_layout_' . esc_attr( $takeout_blog_style[0] ) . '_' . esc_attr( $takeout_columns )
					. ( ! takeout_is_off( $takeout_custom_style )
						? ' post_layout_' . esc_attr( $takeout_custom_style )
							. ' post_layout_' . esc_attr( $takeout_custom_style ) . '_' . esc_attr( $takeout_columns )
						: ''
						)
		);
	takeout_add_blog_animation( $takeout_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'takeout_action_show_layout', $takeout_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $takeout_template_args['slider'] ) || $takeout_columns > 1 || ! takeout_is_off( $takeout_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
