<?php
/**
 * The template to display the user's avatar, bio and socials on the Author page
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.71.0
 */
?>

<div class="author_page author vcard"<?php
	if ( takeout_is_on( takeout_get_theme_option( 'seo_snippets' ) ) ) {
		?> itemprop="author" itemscope="itemscope" itemtype="<?php echo esc_attr( takeout_get_protocol( true ) ); ?>//schema.org/Person"<?php
	}
?>>

	<div class="author_avatar"<?php
		if ( takeout_is_on( takeout_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="image"<?php
		}
	?>>
		<?php
		$takeout_mult = takeout_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120 * $takeout_mult );
		?>
	</div>

	<h4 class="author_title"<?php
		if ( takeout_is_on( takeout_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="name"<?php
		}
	?>><span class="fn"><?php the_author(); ?></span></h4>

	<?php
	$takeout_author_description = get_the_author_meta( 'description' );
	if ( ! empty( $takeout_author_description ) ) {
		?>
		<div class="author_bio"<?php
			if ( takeout_is_on( takeout_get_theme_option( 'seo_snippets' ) ) ) {
				?> itemprop="description"<?php
			}
		?>><?php echo wp_kses( wpautop( $takeout_author_description ), 'takeout_kses_content' ); ?></div>
		<?php
	}
	?>

	<div class="author_details">
		<span class="author_posts_total">
			<?php
			$takeout_posts_total = count_user_posts( get_the_author_meta('ID'), 'post' );
			if ( $takeout_posts_total > 0 ) {
				// Translators: Add the author's posts number to the message
				echo wp_kses( sprintf( _n( '%s article published', '%s articles published', $takeout_posts_total, 'takeout' ),
										'<span class="author_posts_total_value">' . number_format_i18n( $takeout_posts_total ) . '</span>'
								 		),
							'takeout_kses_content'
							);
			} else {
				esc_html_e( 'No posts published.', 'takeout' );
			}
			?>
		</span><?php
			ob_start();
			do_action( 'takeout_action_user_meta', 'author-page' );
			$takeout_socials = ob_get_contents();
			ob_end_clean();
			takeout_show_layout( $takeout_socials,
				'<span class="author_socials"><span class="author_socials_caption">' . esc_html__( 'Follow:', 'takeout' ) . '</span>',
				'</span>'
			);
		?>
	</div>

</div>
