<?php
/**
 * Skin Setup
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.76.0
 */


//--------------------------------------------
// SKIN DEFAULTS
//--------------------------------------------

// Return theme's (skin's) default value for the specified parameter
if ( ! function_exists( 'takeout_theme_defaults' ) ) {
	function takeout_theme_defaults( $name='', $value='' ) {
		$defaults = array(
			'page_width'          => 1290,
			'page_boxed_extra'  => 60,
			'page_fullwide_max' => 1920,
			'page_fullwide_extra' => 60,
			'sidebar_width'       => 410,
			'sidebar_gap'       => 40,
			'grid_gap'          => 30,
			'rad'               => 0
		);
		if ( empty( $name ) ) {
			return $defaults;
		} else {
			if ( $value === '' && isset( $defaults[ $name ] ) ) {
				$value = $defaults[ $name ];
			}
			return $value;
		}
	}
}


// WOOCOMMERCE SETUP
//--------------------------------------------------

// Allow extended layouts for WooCommerce
if ( ! function_exists( 'takeout_skin_woocommerce_allow_extensions' ) ) {
	add_filter( 'takeout_filter_load_woocommerce_extensions', 'takeout_skin_woocommerce_allow_extensions' );
	function takeout_skin_woocommerce_allow_extensions( $allow ) {
		return true;
	}
}


// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)


//--------------------------------------------
// SKIN SETTINGS
//--------------------------------------------
if ( ! function_exists( 'takeout_skin_setup' ) ) {
	add_action( 'after_setup_theme', 'takeout_skin_setup', 1 );
	function takeout_skin_setup() {

		$GLOBALS['TAKEOUT_STORAGE'] = array_merge( $GLOBALS['TAKEOUT_STORAGE'], array(

			// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
			'theme_pro_key'       => 'env-ancora',

			'theme_doc_url'       => '//doc.themerex.net/takeout/',

			'theme_demofiles_url' => '//demofiles.ancorathemes.com/takeout/',
			
			'theme_rate_url'      => '//themeforest.net/downloads',

			'theme_custom_url'    => '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themeinstall',

			'theme_support_url'   => '//themerex.net/support/',

			'theme_download_url'  => '//themeforest.net/user/ancorathemes/portfolio',        // Ancora

			'theme_video_url'     => '//www.youtube.com/channel/UCdIjRh7-lPVHqTTKpaf8PLA',   // Ancora

			'theme_privacy_url'   => '//ancorathemes.com/privacy-policy/',                   // Ancora

			'portfolio_url'       => '//themeforest.net/user/ancorathemes/portfolio',        // Ancora

			// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
			// (i.e. 'children,kindergarten')
			'theme_categories'    => '',
		) );
	}
}


// Add/remove/change Theme Settings
if ( ! function_exists( 'takeout_skin_setup_settings' ) ) {
	add_action( 'after_setup_theme', 'takeout_skin_setup_settings', 1 );
	function takeout_skin_setup_settings() {
		// Example: enable (true) / disable (false) thumbs in the prev/next navigation
		takeout_storage_set_array( 'settings', 'thumbs_in_navigation', false );
		takeout_storage_set_array2( 'required_plugins', 'instagram-feed', 'install', true);
		takeout_storage_set_array2( 'required_plugins', 'revslider', 'install', true);
		takeout_storage_set_array2( 'required_plugins', 'sportspress', 'install', false);
	}
}


// Add/remove/change Theme Options
if ( ! function_exists( 'takeout_skin_setup_options' ) ) {
    add_action( 'after_setup_theme', 'takeout_skin_setup_options', 3 );
    function takeout_skin_setup_options()  {
		takeout_storage_set_array2( 'options', 'header_scheme', 'std', 'default' );
		takeout_storage_set_array2( 'options', 'single_style', 'std', 'style-3' );
    }
}


//--------------------------------------------
// SKIN FONTS
//--------------------------------------------
if ( ! function_exists( 'takeout_skin_setup_fonts' ) ) {
	add_action( 'after_setup_theme', 'takeout_skin_setup_fonts', 1 );
	function takeout_skin_setup_fonts() {
		// Fonts to load when theme start
		// It can be:
		// - Google fonts (specify name, family and styles)
		// - Adobe fonts (specify name, family and link URL)
		// - uploaded fonts (specify name, family), placed in the folder css/font-face/font-name inside the skin folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		takeout_storage_set(
			'load_fonts', array(
				array(
					'name'   => 'DM Sans',
					'family' => 'sans-serif',
					'link'   => '',
					'styles' => 'ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
				),
				array(
					'name'   => 'Inter Tight',
					'family' => 'sans-serif',
					'link'   => '',
					'styles' => 'ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
				),
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		takeout_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags.
		// Default value of 'font-family' may be specified as reference to the array $load_fonts (see above)
		// or as comma-separated string.
		// In the second case (if 'font-family' is specified manually as comma-separated string):
		//    1) Font name with spaces in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		//    2) If font-family inherit a value from the 'Main text' - specify 'inherit' as a value
		// example:
		// Correct:   'font-family' => takeout_get_load_fonts_family_string( $load_fonts[0] )
		// Correct:   'font-family' => 'Roboto,sans-serif'
		// Correct:   'font-family' => '"PT Serif",sans-serif'
		// Incorrect: 'font-family' => 'Roboto, sans-serif'
		// Incorrect: 'font-family' => 'PT Serif,sans-serif'

		$font_description = esc_html__( 'Font settings for the %s of the site. To ensure that the elements scale properly on mobile devices, please use only the following units: "rem", "em" or "ex"', 'takeout' );

		takeout_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'main text', 'takeout' ) ),
					'font-family'     => '"DM Sans",sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.65em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0em',
					'margin-bottom'   => '1.35em',
				),
				'post'    => array(
					'title'           => esc_html__( 'Article text', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'article text', 'takeout' ) ),
					'font-family'     => '',			// Example: '"PR Serif",serif',
					'font-size'       => '',			// Example: '1.286rem',
					'font-weight'     => '',			// Example: '400',
					'font-style'      => '',			// Example: 'normal',
					'line-height'     => '',			// Example: '1.75em',
					'text-decoration' => '',			// Example: 'none',
					'text-transform'  => '',			// Example: 'none',
					'letter-spacing'  => '',			// Example: '',
					'margin-top'      => '',			// Example: '0em',
					'margin-bottom'   => '',			// Example: '1.4em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H1', 'takeout' ) ),
					'font-family'     => '"Inter Tight",sans-serif',
					'font-size'       => '3.353em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.13em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.5px',
					'margin-top'      => '1.05em',
					'margin-bottom'   => '0.42em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H2', 'takeout' ) ),
					'font-family'     => '"Inter Tight",sans-serif',
					'font-size'       => '2.765em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.15em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.5px',
					'margin-top'      => '0.88em',
					'margin-bottom'   => '0.45em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H3', 'takeout' ) ),
					'font-family'     => '"Inter Tight",sans-serif',
					'font-size'       => '2.059em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.15em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1em',
					'margin-bottom'   => '0.57em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H4', 'takeout' ) ),
					'font-family'     => '"Inter Tight",sans-serif',
					'font-size'       => '1.647em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.15em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.15em',
					'margin-bottom'   => '0.55em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H5', 'takeout' ) ),
					'font-family'     => '"Inter Tight",sans-serif',
					'font-size'       => '1.412em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.2em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.33em',
					'margin-bottom'   => '0.45em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H6', 'takeout' ) ),
					'font-family'     => '"Inter Tight",sans-serif',
					'font-size'       => '1.118em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.2em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.5em',
					'margin-bottom'   => '0.45em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'text of the logo', 'takeout' ) ),
					'font-family'     => '"Inter Tight",sans-serif',
					'font-size'       => '1.647em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.15em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'buttons', 'takeout' ) ),
					'font-family'     => '"Inter Tight",sans-serif',
					'font-size'       => '13px',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '20px',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '1.3px',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'input fields, dropdowns and textareas', 'takeout' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '16px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',     // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'post meta (author, categories, publish date, counters, share, etc.)', 'takeout' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '14px',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.4em',
					'margin-bottom'   => '',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'main menu items', 'takeout' ) ),
					'font-family'     => '"Inter Tight",sans-serif',
					'font-size'       => '14px',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '1px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'takeout' ),
					'description'     => sprintf( $font_description, esc_html__( 'dropdown menu items', 'takeout' ) ),
					'font-family'     => '"DM Sans",sans-serif',
					'font-size'       => '15px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
			)
		);

		// Font presets
		takeout_storage_set(
			'font_presets', array(
				'karla' => array(
								'title'  => esc_html__( 'Karla', 'takeout' ),
								'load_fonts' => array(
													// Google font
													array(
														'name'   => 'Dancing Script',
														'family' => 'fantasy',
														'link'   => '',
														'styles' => '300,400,700',
													),
													// Google font
													array(
														'name'   => 'Sansita Swashed',
														'family' => 'fantasy',
														'link'   => '',
														'styles' => '300,400,700',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Dancing Script",fantasy',
														'font-size'       => '1.25rem',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
														'font-size'       => '4em',
													),
													'h2'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h3'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h4'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h5'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h6'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'logo'    => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'button'  => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'submenu' => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
												),
							),
				'roboto' => array(
								'title'  => esc_html__( 'Roboto', 'takeout' ),
								'load_fonts' => array(
													// Google font
													array(
														'name'   => 'Noto Sans JP',
														'family' => 'serif',
														'link'   => '',
														'styles' => '300,300italic,400,400italic,700,700italic',
													),
													// Google font
													array(
														'name'   => 'Merriweather',
														'family' => 'sans-serif',
														'link'   => '',
														'styles' => '300,300italic,400,400italic,700,700italic',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Noto Sans JP",serif',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h2'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h3'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h4'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h5'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h6'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'logo'    => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'button'  => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'submenu' => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
												),
							),
				'garamond' => array(
								'title'  => esc_html__( 'Garamond', 'takeout' ),
								'load_fonts' => array(
													// Adobe font
													array(
														'name'   => 'Europe',
														'family' => 'sans-serif',
														'link'   => 'https://use.typekit.net/qmj1tmx.css',
														'styles' => '',
													),
													// Adobe font
													array(
														'name'   => 'Sofia Pro',
														'family' => 'sans-serif',
														'link'   => 'https://use.typekit.net/qmj1tmx.css',
														'styles' => '',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Sofia Pro",sans-serif',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h2'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h3'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h4'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h5'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h6'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'logo'    => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'button'  => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'submenu' => array(
														'font-family'     => 'Europe,sans-serif',
													),
												),
							),
			)
		);
	}
}


//--------------------------------------------
// COLOR SCHEMES
//--------------------------------------------
if ( ! function_exists( 'takeout_skin_setup_schemes' ) ) {
	add_action( 'after_setup_theme', 'takeout_skin_setup_schemes', 1 );
	function takeout_skin_setup_schemes() {

		// Theme colors for customizer
		// Attention! Inner scheme must be last in the array below
		takeout_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'takeout' ),
					'description' => esc_html__( 'Colors of the main content area', 'takeout' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'takeout' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'takeout' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'takeout' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'takeout' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'takeout' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'takeout' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'takeout' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'takeout' ),
				),
			)
		);

		takeout_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'takeout' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'takeout' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'takeout' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'takeout' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'takeout' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'takeout' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'takeout' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'takeout' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'takeout' ),
					'description' => esc_html__( 'Color of the text inside this block', 'takeout' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'takeout' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'takeout' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'takeout' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'takeout' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'takeout' ),
					'description' => esc_html__( 'Color of the links inside this block', 'takeout' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'takeout' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'takeout' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Accent 2', 'takeout' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'takeout' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Accent 2 hover', 'takeout' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'takeout' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Accent 3', 'takeout' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'takeout' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Accent 3 hover', 'takeout' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'takeout' ),
				),
			)
		);

		// Default values for each color scheme
		$schemes = array(

			// Color scheme: 'default'
			'default' => array(
				'title'    => esc_html__( 'Default', 'takeout' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FCFCF5', // // ffffff
					'bd_color'         => '#E2E2D8', // ok

					// Text and links colors
					'text'             => '#6E6F72', // ok
					'text_light'       => '#9E9FA1', // ok
					'text_dark'        => '#242221', // ok
					'text_link'        => '#FA5918', // ok
					'text_hover'       => '#E84A0A', // ok
					'text_link2'       => '#D63920', // ok
					'text_hover2'      => '#CD260C', // ok
					'text_link3'       => '#46BA3C', // ok
					'text_hover3'      => '#35A62B', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#ffffff', // // FCFCF5
					'alter_bg_hover'   => '#F8F8EA', // // F8F8EA
					'alter_bd_color'   => '#E2E2D8', // ok
					'alter_bd_hover'   => '#CECEC3', // ok
					'alter_text'       => '#6E6F72', // ok
					'alter_light'      => '#9E9FA1', // ok
					'alter_dark'       => '#242221', // ok
					'alter_link'       => '#FA5918', // ok
					'alter_hover'      => '#E84A0A', // ok
					'alter_link2'      => '#D63920', // ok
					'alter_hover2'     => '#CD260C', // ok
					'alter_link3'      => '#46BA3C', // ok
					'alter_hover3'     => '#35A62B', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#181919', // ok
					'extra_bg_hover'   => '#2E2F2F', // ok
					'extra_bd_color'   => '#414141', // ok
					'extra_bd_hover'   => '#565656', // ok
					'extra_text'       => '#CDCDCD', // ok
					'extra_light'      => '#9B9C9C', // ok
					'extra_dark'       => '#ffffff', // ok
					'extra_link'       => '#FA5918', // ok
					'extra_hover'      => '#ffffff', // ok
					'extra_link2'      => '#D63920', // ok
					'extra_hover2'     => '#CD260C', // ok
					'extra_link3'      => '#46BA3C', // ok
					'extra_hover3'     => '#35A62C', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#E2E2D8', // ok
					'input_bd_hover'   => '#242221', // ok
					'input_text'       => '#6E6F72', // ok
					'input_light'      => '#6E6F72', // ok
					'input_dark'       => '#242221', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#242221', // ok
					'inverse_link'     => '#ffffff', //
					'inverse_hover'    => '#ffffff', //
				),
			),

			// Color scheme: 'default'
			'light' => array(
				'title'    => esc_html__( 'Light', 'takeout' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#ffffff', // ok
					'bd_color'         => '#E2E2D8', // ok

					// Text and links colors
					'text'             => '#6E6F72', // ok
					'text_light'       => '#9E9FA1', // ok
					'text_dark'        => '#242221', // ok
					'text_link'        => '#FA5918', // ok
					'text_hover'       => '#E84A0A', // ok
					'text_link2'       => '#D63920', // ok
					'text_hover2'      => '#CD260C', // ok
					'text_link3'       => '#46BA3C', // ok
					'text_hover3'      => '#35A62B', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FCFCF5', // ok
					'alter_bg_hover'   => '#F8F8EA', // ok
					'alter_bd_color'   => '#E2E2D8', // ok
					'alter_bd_hover'   => '#CECEC3', // ok
					'alter_text'       => '#6E6F72', // ok
					'alter_light'      => '#9E9FA1', // ok
					'alter_dark'       => '#242221', // ok
					'alter_link'       => '#FA5918', // ok
					'alter_hover'      => '#E84A0A', // ok
					'alter_link2'      => '#D63920', // ok
					'alter_hover2'     => '#CD260C', // ok
					'alter_link3'      => '#46BA3C', // ok
					'alter_hover3'     => '#35A62B', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#181919', // ok
					'extra_bg_hover'   => '#2E2F2F', // ok
					'extra_bd_color'   => '#414141', // ok
					'extra_bd_hover'   => '#565656', // ok
					'extra_text'       => '#CDCDCD', // ok
					'extra_light'      => '#9B9C9C', // ok
					'extra_dark'       => '#ffffff', // ok
					'extra_link'       => '#FA5918', // ok
					'extra_hover'      => '#ffffff', // ok
					'extra_link2'      => '#D63920', // ok
					'extra_hover2'     => '#CD260C', // ok
					'extra_link3'      => '#46BA3C', // ok
					'extra_hover3'     => '#35A62C', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#E2E2D8', // ok
					'input_bd_hover'   => '#242221', // ok
					'input_text'       => '#6E6F72', // ok
					'input_light'      => '#6E6F72', // ok
					'input_dark'       => '#242221', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#242221', // ok
					'inverse_link'     => '#ffffff', //
					'inverse_hover'    => '#ffffff', //
				),
			),

			// Color scheme: 'dark'
			'dark'    => array(
				'title'    => esc_html__( 'Dark', 'takeout' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#080808', // ok
					'bd_color'         => '#414141', // ok

					// Text and links colors
					'text'             => '#CDCDCD', // ok
					'text_light'       => '#9B9C9C', // ok
					'text_dark'        => '#FFFFFF', // ok
					'text_link'        => '#FA5918', // ok
					'text_hover'       => '#E84A0A', // ok
					'text_link2'       => '#D63920', // ok
					'text_hover2'      => '#CD260C', // ok
					'text_link3'       => '#46BA3C', // ok
					'text_hover3'      => '#35A62B', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#101212', // ok
					'alter_bg_hover'   => '#232424', // ok
					'alter_bd_color'   => '#414141', // ok
					'alter_bd_hover'   => '#565656', // ok
					'alter_text'       => '#CDCDCD', // ok
					'alter_light'      => '#9B9C9C', // ok
					'alter_dark'       => '#FFFFFF', // ok
					'alter_link'       => '#FA5918', // ok
					'alter_hover'      => '#E84A0A', // ok
					'alter_link2'      => '#D63920', // ok
					'alter_hover2'     => '#CD260C', // ok
					'alter_link3'      => '#46BA3C', // ok
					'alter_hover3'     => '#35A62B', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#181919', // ok
					'extra_bg_hover'   => '#2E2F2F', // ok
					'extra_bd_color'   => '#414141', // ok
					'extra_bd_hover'   => '#565656', // ok
					'extra_text'       => '#CDCDCD', // ok
					'extra_light'      => '#9B9C9C', // ok
					'extra_dark'       => '#ffffff', // ok
					'extra_link'       => '#FA5918', // ok
					'extra_hover'      => '#ffffff', // ok
					'extra_link2'      => '#D63920', // ok
					'extra_hover2'     => '#CD260C', // ok
					'extra_link3'      => '#46BA3C', // ok
					'extra_hover3'     => '#35A62C', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#414141', // ok
					'input_bd_hover'   => '#565656', // ok
					'input_text'       => '#CDCDCD', // ok
					'input_light'      => '#CDCDCD', // ok
					'input_dark'       => '#ffffff',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#FFFFFF', // 
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#000000', //
					'inverse_link'     => '#ffffff', //
					'inverse_hover'    => '#000000', //
				),
			),


			// Color scheme: 'fast-food-light'
			'fast-food-light' => array(
				'title'    => esc_html__( 'Fast Food Light', 'takeout' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FEFBE7', // ok
					'bd_color'         => '#DEDBC7', // ok

					// Text and links colors
					'text'             => '#797C7F', // ok
					'text_light'       => '#989AA0', // ok
					'text_dark'        => '#1F242E', // ok
					'text_link'        => '#ED1B2E', // ok
					'text_hover'       => '#DC0E20', // ok
					'text_link2'       => '#FCB913', // ok
					'text_hover2'      => '#FCAD13', // ok
					'text_link3'       => '#C1D100', // ok
					'text_hover3'      => '#B1C000', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F9F5DB', // ok
					'alter_bg_hover'   => '#F1EED6', // ok
					'alter_bd_color'   => '#DEDBC7', // ok
					'alter_bd_hover'   => '#D1CFBF', // ok
					'alter_text'       => '#797C7F', // ok
					'alter_light'      => '#989AA0', // ok
					'alter_dark'       => '#1F242E', // ok
					'alter_link'       => '#ED1B2E', // ok
					'alter_hover'      => '#DC0E20', // ok
					'alter_link2'      => '#FCB913', // ok
					'alter_hover2'     => '#FCAD13', // ok
					'alter_link3'      => '#C1D100', // ok
					'alter_hover3'     => '#B1C000', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1A2126', // ok
					'extra_bg_hover'   => '#2B3339', // ok
					'extra_bd_color'   => '#3C444A', // ok
					'extra_bd_hover'   => '#495258', // ok
					'extra_text'       => '#CBCAC7', // ok
					'extra_light'      => '#929798', // ok
					'extra_dark'       => '#FEFBEB', // ok
					'extra_link'       => '#ED1B2E', // ok
					'extra_hover'      => '#FEFBEB', // ok
					'extra_link2'      => '#FCB913', // ok
					'extra_hover2'     => '#FCAD13', // ok
					'extra_link3'      => '#C1D100', // ok
					'extra_hover3'     => '#B1C000', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#DEDBC7', // ok
					'input_bd_hover'   => '#1F242E', // ok
					'input_text'       => '#797C7F', // ok
					'input_light'      => '#797C7F', // ok
					'input_dark'       => '#1F242E', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#1F242E', // ok
					'inverse_link'     => '#ffffff', //
					'inverse_hover'    => '#ffffff', //
				),
			),

			// Color scheme: 'fast-food-dark'
			'fast-food-dark'    => array(
				'title'    => esc_html__( 'Fast Food Dark', 'takeout' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#0B0E11', // ok
					'bd_color'         => '#3C444A', // ok

					// Text and links colors
					'text'             => '#CBCAC7', // ok
					'text_light'       => '#929798', // ok
					'text_dark'        => '#FEFBEB', // ok
					'text_link'        => '#ED1B2E', // ok
					'text_hover'       => '#DC0E20', // ok
					'text_link2'       => '#FCB913', // ok
					'text_hover2'      => '#FCAD13', // ok
					'text_link3'       => '#C1D100', // ok
					'text_hover3'      => '#B1C000', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#141A1F', // ok
					'alter_bg_hover'   => '#21292F', // ok
					'alter_bd_color'   => '#3C444A', // ok
					'alter_bd_hover'   => '#495258', // ok
					'alter_text'       => '#CBCAC7', // ok
					'alter_light'      => '#929798', // ok
					'alter_dark'       => '#FEFBEB', // ok
					'alter_link'       => '#ED1B2E', // ok
					'alter_hover'      => '#DC0E20', // ok
					'alter_link2'      => '#FCB913', // ok
					'alter_hover2'     => '#FCAD13', // ok
					'alter_link3'      => '#C1D100', // ok
					'alter_hover3'     => '#B1C000', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1A2126', // ok
					'extra_bg_hover'   => '#2B3339', // ok
					'extra_bd_color'   => '#3C444A', // ok
					'extra_bd_hover'   => '#495258', // ok
					'extra_text'       => '#CBCAC7', // ok
					'extra_light'      => '#929798', // ok
					'extra_dark'       => '#FEFBEB', // ok
					'extra_link'       => '#ED1B2E', // ok
					'extra_hover'      => '#ffffff', // ok
					'extra_link2'      => '#FCB913', // ok
					'extra_hover2'     => '#FCAD13', // ok
					'extra_link3'      => '#C1D100', // ok
					'extra_hover3'     => '#B1C000', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', // 
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#3C444A', // ok
					'input_bd_hover'   => '#495258', // ok
					'input_text'       => '#CBCAC7', // ok
					'input_light'      => '#CBCAC7', // ok
					'input_dark'       => '#FEFBEB', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#FEFBEB', // ok
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#000000', //
					'inverse_link'     => '#ffffff', //
					'inverse_hover'    => '#000000', //
				),
			),


			// Color scheme: 'tea-coffee-default'
			'tea-coffee-default' => array(
				'title'    => esc_html__( 'Tea Coffee Default', 'takeout' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FAF7EB', // ok
					'bd_color'         => '#CECBBE', // ok

					// Text and links colors
					'text'             => '#7E7470', // ok
					'text_light'       => '#8F8683', // ok
					'text_dark'        => '#351C15', // ok
					'text_link'        => '#EC5708', // ok
					'text_hover'       => '#DE4D00', // ok
					'text_link2'       => '#855043', // ok
					'text_hover2'      => '#794133', // ok
					'text_link3'       => '#D96B1A', // ok
					'text_hover3'      => '#CC6214', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF', // ok
					'alter_bg_hover'   => '#F4EFDD', // ok
					'alter_bd_color'   => '#CECBBE', // ok
					'alter_bd_hover'   => '#BCB9AC', // ok
					'alter_text'       => '#7E7470', // ok
					'alter_light'      => '#8F8683', // ok
					'alter_dark'       => '#351C15', // ok
					'alter_link'       => '#EC5708', // ok
					'alter_hover'      => '#DE4D00', // ok
					'alter_link2'      => '#855043', // ok
					'alter_hover2'     => '#794133', // ok
					'alter_link3'      => '#D96B1A', // ok
					'alter_hover3'     => '#CC6214', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#291A16', // ok
					'extra_bg_hover'   => '#392B27', // ok
					'extra_bd_color'   => '#403330', // ok
					'extra_bd_hover'   => '#4B413E', // ok
					'extra_text'       => '#D4CFCE', // ok
					'extra_light'      => '#A59F9E', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#EC5708', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#855043', // ok
					'extra_hover2'     => '#794133', // ok
					'extra_link3'      => '#D96B1A', // ok
					'extra_hover3'     => '#CC6214', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#CECBBE', // ok
					'input_bd_hover'   => '#351C15', // ok
					'input_text'       => '#7E7470', // ok
					'input_light'      => '#7E7470', // ok
					'input_dark'       => '#351C15', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#351C15', // ok
					'inverse_link'     => '#ffffff', //
					'inverse_hover'    => '#ffffff', //
				),
			),

			// Color scheme: 'tea-coffee-light'
			'tea-coffee-light' => array(
				'title'    => esc_html__( 'Tea Coffee Light', 'takeout' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFFFFF', // ok
					'bd_color'         => '#CECBBE', // ok

					// Text and links colors
					'text'             => '#7E7470', // ok
					'text_light'       => '#8F8683', // ok
					'text_dark'        => '#351C15', // ok
					'text_link'        => '#EC5708', // ok
					'text_hover'       => '#DE4D00', // ok
					'text_link2'       => '#855043', // ok
					'text_hover2'      => '#794133', // ok
					'text_link3'       => '#D96B1A', // ok
					'text_hover3'      => '#CC6214', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FAF7EB', // ok
					'alter_bg_hover'   => '#F4EFDD', // ok
					'alter_bd_color'   => '#CECBBE', // ok
					'alter_bd_hover'   => '#BCB9AC', // ok
					'alter_text'       => '#7E7470', // ok
					'alter_light'      => '#8F8683', // ok
					'alter_dark'       => '#351C15', // ok
					'alter_link'       => '#EC5708', // ok
					'alter_hover'      => '#DE4D00', // ok
					'alter_link2'      => '#855043', // ok
					'alter_hover2'     => '#794133', // ok
					'alter_link3'      => '#D96B1A', // ok
					'alter_hover3'     => '#CC6214', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#291A16', // ok
					'extra_bg_hover'   => '#392B27', // ok
					'extra_bd_color'   => '#403330', // ok
					'extra_bd_hover'   => '#4B413E', // ok
					'extra_text'       => '#D4CFCE', // ok
					'extra_light'      => '#A59F9E', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#EC5708', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#855043', // ok
					'extra_hover2'     => '#794133', // ok
					'extra_link3'      => '#D96B1A', // ok
					'extra_hover3'     => '#CC6214', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#CECBBE', // ok
					'input_bd_hover'   => '#351C15', // ok
					'input_text'       => '#7E7470', // ok
					'input_light'      => '#7E7470', // ok
					'input_dark'       => '#351C15', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#351C15', // ok
					'inverse_link'     => '#ffffff', //
					'inverse_hover'    => '#ffffff', //
				),
			),

			// Color scheme: 'tea-coffee-dark'
			'tea-coffee-dark'    => array(
				'title'    => esc_html__( 'Tea Coffee Dark', 'takeout' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#100806', // ok
					'bd_color'         => '#403330', // ok

					// Text and links colors
					'text'             => '#D4CFCE', // ok
					'text_light'       => '#A59F9E', // ok
					'text_dark'        => '#FFFFFF', // ok
					'text_link'        => '#EC5708', // ok
					'text_hover'       => '#DE4D00', // ok
					'text_link2'       => '#855043', // ok
					'text_hover2'      => '#794133', // ok
					'text_link3'       => '#D96B1A', // ok
					'text_hover3'      => '#CC6214', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#1F100C', // ok
					'alter_bg_hover'   => '#2F201D', // ok
					'alter_bd_color'   => '#403330', // ok
					'alter_bd_hover'   => '#4B413E', // ok
					'alter_text'       => '#D4CFCE', // ok
					'alter_light'      => '#A59F9E', // ok
					'alter_dark'       => '#FFFFFF', // ok
					'alter_link'       => '#EC5708', // ok
					'alter_hover'      => '#DE4D00', // ok
					'alter_link2'      => '#855043', // ok
					'alter_hover2'     => '#794133', // ok
					'alter_link3'      => '#D96B1A', // ok
					'alter_hover3'     => '#CC6214', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#291A16', // ok
					'extra_bg_hover'   => '#392B27', // ok
					'extra_bd_color'   => '#403330', // ok
					'extra_bd_hover'   => '#4B413E', // ok
					'extra_text'       => '#D4CFCE', // ok
					'extra_light'      => '#A59F9E', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#EC5708', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#855043', // ok
					'extra_hover2'     => '#794133', // ok
					'extra_link3'      => '#D96B1A', // ok
					'extra_hover3'     => '#CC6214', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', // 
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#403330', // ok
					'input_bd_hover'   => '#4B413E', // ok
					'input_text'       => '#D4CFCE', // ok
					'input_light'      => '#D4CFCE', // ok
					'input_dark'       => '#FFFFFF', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#FFFFFF', // ok
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#351C15', // ok
					'inverse_link'     => '#ffffff', //
					'inverse_hover'    => '#000000', //
				),
			),


			// Color scheme: 'cream-default'
			'cream-default' => array(
				'title'    => esc_html__( 'Cream Default', 'takeout' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFFFF5', // ok
					'bd_color'         => '#C9C2B6', // ok

					// Text and links colors
					'text'             => '#8A7C78', // ok
					'text_light'       => '#A49692', // ok
					'text_dark'        => '#D96B1A', // ok
					'text_link'        => '#C55B0D', // ok
					'text_hover'       => '#AC4C05', // ok
					'text_link2'       => '#E2C74F', // ok
					'text_hover2'      => '#D3B634', // ok
					'text_link3'       => '#D88B99', // ok
					'text_hover3'      => '#C87685', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F9FAE2', // ok
					'alter_bg_hover'   => '#F4F4E6', // ok
					'alter_bd_color'   => '#C9C2B6', // ok
					'alter_bd_hover'   => '#B2AB9E', // ok
					'alter_text'       => '#8A7C78', // ok
					'alter_light'      => '#A49692', // ok
					'alter_dark'       => '#D96B1A', // ok
					'alter_link'       => '#C55B0D', // ok
					'alter_hover'      => '#AC4C05', // ok
					'alter_link2'      => '#E2C74F', // ok
					'alter_hover2'     => '#D3B634', // ok
					'alter_link3'      => '#D88B99', // ok
					'alter_hover3'     => '#C87685', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#262628', // ok
					'extra_bg_hover'   => '#36363D', // ok
					'extra_bd_color'   => '#43434C', // ok
					'extra_bd_hover'   => '#5D5D68', // ok
					'extra_text'       => '#DADADA', // ok
					'extra_light'      => '#A3A3A3', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#C55B0D', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#E2C74F', // ok
					'extra_hover2'     => '#D3B634', // ok
					'extra_link3'      => '#D88B99', // ok
					'extra_hover3'     => '#C87685', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#C9C2B6', // ok
					'input_bd_hover'   => '#D96B1A', // ok
					'input_text'       => '#8A7C78', // ok
					'input_light'      => '#8A7C78', // ok
					'input_dark'       => '#D96B1A', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#D96B1A', // ok
					'inverse_link'     => '#ffffff', //
					'inverse_hover'    => '#ffffff', //
				),
			),

			// Color scheme: 'cream-light'
			'cream-light' => array(
				'title'    => esc_html__( 'Cream Light', 'takeout' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F9FAE2', // ok
					'bd_color'         => '#C9C2B6', // ok

					// Text and links colors
					'text'             => '#8A7C78', // ok
					'text_light'       => '#A49692', // ok
					'text_dark'        => '#D96B1A', // ok
					'text_link'        => '#C55B0D', // ok
					'text_hover'       => '#AC4C05', // ok
					'text_link2'       => '#E2C74F', // ok
					'text_hover2'      => '#D3B634', // ok
					'text_link3'       => '#D88B99', // ok
					'text_hover3'      => '#C87685', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFF5', // ok
					'alter_bg_hover'   => '#F4F4E6', // ok
					'alter_bd_color'   => '#C9C2B6', // ok
					'alter_bd_hover'   => '#B2AB9E', // ok
					'alter_text'       => '#8A7C78', // ok
					'alter_light'      => '#A49692', // ok
					'alter_dark'       => '#D96B1A', // ok
					'alter_link'       => '#C55B0D', // ok
					'alter_hover'      => '#AC4C05', // ok
					'alter_link2'      => '#E2C74F', // ok
					'alter_hover2'     => '#D3B634', // ok
					'alter_link3'      => '#D88B99', // ok
					'alter_hover3'     => '#C87685', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#262628', // ok
					'extra_bg_hover'   => '#36363D', // ok
					'extra_bd_color'   => '#43434C', // ok
					'extra_bd_hover'   => '#5D5D68', // ok
					'extra_text'       => '#DADADA', // ok
					'extra_light'      => '#A3A3A3', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#C55B0D', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#E2C74F', // ok
					'extra_hover2'     => '#D3B634', // ok
					'extra_link3'      => '#D88B99', // ok
					'extra_hover3'     => '#C87685', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#C9C2B6', // ok
					'input_bd_hover'   => '#D96B1A', // ok
					'input_text'       => '#8A7C78', // ok
					'input_light'      => '#8A7C78', // ok
					'input_dark'       => '#D96B1A', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#D96B1A', // ok
					'inverse_link'     => '#ffffff', //
					'inverse_hover'    => '#ffffff', //
				),
			),

			// Color scheme: 'cream-dark'
			'cream-dark'    => array(
				'title'    => esc_html__( 'Cream Dark', 'takeout' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#0E0E0F', // ok
					'bd_color'         => '#43434D', // ok

					// Text and links colors
					'text'             => '#DADADA', // ok
					'text_light'       => '#A3A3A3', // ok
					'text_dark'        => '#FFFFFF', // ok
					'text_link'        => '#C55B0D', // ok
					'text_hover'       => '#AC4C05', // ok
					'text_link2'       => '#E2C74F', // ok
					'text_hover2'      => '#D3B634', // ok
					'text_link3'       => '#D88B99', // ok
					'text_hover3'      => '#C87685', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#18181A', // ok
					'alter_bg_hover'   => '#2D2D32', // ok
					'alter_bd_color'   => '#43434D', // ok
					'alter_bd_hover'   => '#5D5D68', // ok
					'alter_text'       => '#DADADA', // ok
					'alter_light'      => '#A3A3A3', // ok
					'alter_dark'       => '#FFFFFF', // ok
					'alter_link'       => '#C55B0D', // ok
					'alter_hover'      => '#AC4C05', // ok
					'alter_link2'      => '#E2C74F', // ok
					'alter_hover2'     => '#D3B634', // ok
					'alter_link3'      => '#D88B99', // ok
					'alter_hover3'     => '#C87685', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#262628', // ok
					'extra_bg_hover'   => '#36363D', // ok
					'extra_bd_color'   => '#43434C', // ok
					'extra_bd_hover'   => '#5D5D68', // ok
					'extra_text'       => '#DADADA', // ok
					'extra_light'      => '#A3A3A3', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#C55B0D', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#E2C74F', // ok
					'extra_hover2'     => '#D3B634', // ok
					'extra_link3'      => '#D88B99', // ok
					'extra_hover3'     => '#C87685', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', // 
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#43434D', // ok
					'input_bd_hover'   => '#5D5D68', // ok
					'input_text'       => '#DADADA', // ok
					'input_light'      => '#DADADA', // ok
					'input_dark'       => '#FFFFFF', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#FFFFFF', // 
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#351C15', // 
					'inverse_link'     => '#ffffff', //
					'inverse_hover'    => '#000000', //
				),
			),

		);
		takeout_storage_set( 'schemes', $schemes );
		takeout_storage_set( 'schemes_original', $schemes );

		// Add names of additional colors
		//---> For example:
		//---> takeout_storage_set_array( 'scheme_color_names', 'new_color1', array(
		//---> 	'title'       => __( 'New color 1', 'takeout' ),
		//---> 	'description' => __( 'Description of the new color 1', 'takeout' ),
		//---> ) );


		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		takeout_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_08' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.8,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_00' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
                'alter_dark_015'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.15,
                ),
                'alter_dark_02'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.2,
                ),
                'alter_dark_05'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.5,
                ),
                'alter_dark_08'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.8,
                ),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_05' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.5,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
                'text_dark_003'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.03,
                ),
                'text_dark_005'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.05,
                ),
                'text_dark_008'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.08,
                ),
				'text_dark_015'      => array(
					'color' => 'text_dark',
					'alpha' => 0.15,
				),
				'text_dark_02'      => array(
					'color' => 'text_dark',
					'alpha' => 0.2,
				),
                'text_dark_03'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.3,
                ),
                'text_dark_05'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.5,
                ),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
                'text_dark_08'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.8,
                ),
                'text_link_007'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.07,
                ),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
                'text_link_03'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.3,
                ),
				'text_link_04'      => array(
					'color' => 'text_link',
					'alpha' => 0.4,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link2_08'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.8,
                ),
                'text_link2_007'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.07,
                ),
				'text_link2_02'      => array(
					'color' => 'text_link2',
					'alpha' => 0.2,
				),
                'text_link2_03'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.3,
                ),
				'text_link2_05'      => array(
					'color' => 'text_link2',
					'alpha' => 0.5,
				),
                'text_link3_007'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.07,
                ),
				'text_link3_02'      => array(
					'color' => 'text_link3',
					'alpha' => 0.2,
				),
                'text_link3_03'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.3,
                ),
                'inverse_text_03'      => array(
                    'color' => 'inverse_text',
                    'alpha' => 0.3,
                ),
                'inverse_link_08'      => array(
                    'color' => 'inverse_link',
                    'alpha' => 0.8,
                ),
                'inverse_hover_08'      => array(
                    'color' => 'inverse_hover',
                    'alpha' => 0.8,
                ),
				'text_dark_blend'   => array(
					'color'      => 'text_dark',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Simple scheme editor: lists the colors to edit in the "Simple" mode.
		// For each color you can set the array of 'slave' colors and brightness factors that are used to generate new values,
		// when 'main' color is changed
		// Leave 'slave' arrays empty if your scheme does not have a color dependency
		takeout_storage_set(
			'schemes_simple', array(
				'text_link'        => array(),
				'text_hover'       => array(),
				'text_link2'       => array(),
				'text_hover2'      => array(),
				'text_link3'       => array(),
				'text_hover3'      => array(),
				'alter_link'       => array(),
				'alter_hover'      => array(),
				'alter_link2'      => array(),
				'alter_hover2'     => array(),
				'alter_link3'      => array(),
				'alter_hover3'     => array(),
				'extra_link'       => array(),
				'extra_hover'      => array(),
				'extra_link2'      => array(),
				'extra_hover2'     => array(),
				'extra_link3'      => array(),
				'extra_hover3'     => array(),
			)
		);

		// Parameters to set order of schemes in the css
		takeout_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// Color presets
		takeout_storage_set(
			'color_presets', array(
				'autumn' => array(
								'title'  => esc_html__( 'Autumn', 'takeout' ),
								'colors' => array(
												'default' => array(
																	'text_link'  => '#d83938',
																	'text_hover' => '#f2b232',
																	),
												'dark' => array(
																	'text_link'  => '#d83938',
																	'text_hover' => '#f2b232',
																	)
												)
							),
				'green' => array(
								'title'  => esc_html__( 'Natural Green', 'takeout' ),
								'colors' => array(
												'default' => array(
																	'text_link'  => '#75ac78',
																	'text_hover' => '#378e6d',
																	),
												'dark' => array(
																	'text_link'  => '#75ac78',
																	'text_hover' => '#378e6d',
																	)
												)
							),
			)
		);
	}
}

// Enqueue clone specific style
if ( ! function_exists( 'takeout_clone_frontend_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'takeout_clone_frontend_scripts', 1150 );
	function takeout_clone_frontend_scripts() {
		$takeout_url = takeout_get_file_url( takeout_skins_get_current_skin_dir() . 'extra-style.css' );
		if ( '' != $takeout_url ) {
			wp_enqueue_style( 'takeout-extra-skin-' . esc_attr( takeout_skins_get_current_skin_name() ), $takeout_url, array(), null );
		}
	}
}


// Activation methods
if ( ! function_exists( 'takeout_skin_filter_activation_methods2' ) ) {
    add_filter( 'trx_addons_filter_activation_methods', 'takeout_skin_filter_activation_methods2', 11, 1 );
    function takeout_skin_filter_activation_methods2( $args ) {
        $args['elements_key'] = true;
        return $args;
    }
}