<?php
/**
 * Required plugins
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
if ( ! function_exists( 'takeout_skin_required_plugins' ) ) {
	add_action( 'after_setup_theme', 'takeout_skin_required_plugins', -1 );
	/**
	 * Create the list of required plugins for the skin/theme.
	 * Priority -1 is used to create the list of plugins before the rest skin/theme actions.
	 * 
	 * @hooked 'after_setup_theme', -1
	 */
	function takeout_skin_required_plugins() {
		$takeout_theme_required_plugins_groups = array(
		'core'          => esc_html__( 'Core', 'takeout' ),
		'page_builders' => esc_html__( 'Page Builders', 'takeout' ),
		'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'takeout' ),
		'socials'       => esc_html__( 'Socials and Communities', 'takeout' ),
		'events'        => esc_html__( 'Events and Appointments', 'takeout' ),
		'content'       => esc_html__( 'Content', 'takeout' ),
		'other'         => esc_html__( 'Other', 'takeout' ),
		);
		$takeout_theme_required_plugins = array(
			'trx_addons'                 => array(
				'title'       => esc_html__( 'ThemeREX Addons', 'takeout' ),
				'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'takeout' ),
				'required'    => true,
				'logo'        => 'trx_addons.png',
				'group'       => $takeout_theme_required_plugins_groups['core'],
			),
			'elementor'                  => array(
				'title'       => esc_html__( 'Elementor', 'takeout' ),
				'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'takeout' ),
				'required'    => false,
				'logo'        => 'elementor.png',
				'group'       => $takeout_theme_required_plugins_groups['page_builders'],
			),
			'gutenberg'                  => array(
				'title'       => esc_html__( 'Gutenberg', 'takeout' ),
				'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'takeout' ),
				'required'    => false,
				'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'gutenberg.png',
				'group'       => $takeout_theme_required_plugins_groups['page_builders'],
			),
			'js_composer'                => array(
				'title'       => esc_html__( 'WPBakery PageBuilder', 'takeout' ),
				'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'takeout' ),
				'required'    => false,
				'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'js_composer.jpg',
				'group'       => $takeout_theme_required_plugins_groups['page_builders'],
			),
			'woocommerce'                => array(
				'title'       => esc_html__( 'WooCommerce', 'takeout' ),
				'description' => esc_html__( "Connect the store to your website and start selling now", 'takeout' ),
				'required'    => false,
				'logo'        => 'woocommerce.png',
				'group'       => $takeout_theme_required_plugins_groups['ecommerce'],
			),
			'elegro-payment'             => array(
				'title'       => esc_html__( 'Elegro Crypto Payment', 'takeout' ),
				'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'takeout' ),
				'required'    => false,
				'install'     => false, // TRX_addons has marked the "Elegro Crypto Payment" plugin as obsolete and no longer recommends it for installation, even if it had been previously recommended by the theme
				'logo'        => 'elegro-payment.png',
				'group'       => $takeout_theme_required_plugins_groups['ecommerce'],
			),
			'instagram-feed'             => array(
				'title'       => esc_html__( 'Instagram Feed', 'takeout' ),
				'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'takeout' ),
				'required'    => false,
				'logo'        => 'instagram-feed.png',
				'group'       => $takeout_theme_required_plugins_groups['socials'],
			),
			'mailchimp-for-wp'           => array(
				'title'       => esc_html__( 'MailChimp for WP', 'takeout' ),
				'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'takeout' ),
				'required'    => false,
				'logo'        => 'mailchimp-for-wp.png',
				'group'       => $takeout_theme_required_plugins_groups['socials'],
			),
			'booked'                     => array(
				'title'       => esc_html__( 'Booked Appointments', 'takeout' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => 'booked.png',
				'group'       => $takeout_theme_required_plugins_groups['events'],
			),
			'quickcal'                     => array(
				'title'       => esc_html__( 'QuickCal', 'takeout' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => 'quickcal.png',
				'group'       => $takeout_theme_required_plugins_groups['events'],
			),
			'the-events-calendar'        => array(
				'title'       => esc_html__( 'The Events Calendar', 'takeout' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => 'the-events-calendar.png',
				'group'       => $takeout_theme_required_plugins_groups['events'],
			),
			'contact-form-7'             => array(
				'title'       => esc_html__( 'Contact Form 7', 'takeout' ),
				'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'takeout' ),
				'required'    => false,
				'logo'        => 'contact-form-7.png',
				'group'       => $takeout_theme_required_plugins_groups['content'],
			),

			'latepoint'                  => array(
				'title'       => esc_html__( 'LatePoint', 'takeout' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => takeout_get_file_url( 'plugins/latepoint/latepoint.png' ),
				'group'       => $takeout_theme_required_plugins_groups['events'],
			),
			'advanced-popups'                  => array(
				'title'       => esc_html__( 'Advanced Popups', 'takeout' ),
				'description' => '',
				'required'    => false,
				'logo'        => takeout_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
				'group'       => $takeout_theme_required_plugins_groups['content'],
			),
			'devvn-image-hotspot'                  => array(
				'title'       => esc_html__( 'Image Hotspot by DevVN', 'takeout' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => takeout_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
				'group'       => $takeout_theme_required_plugins_groups['content'],
			),
			'ti-woocommerce-wishlist'                  => array(
				'title'       => esc_html__( 'TI WooCommerce Wishlist', 'takeout' ),
				'description' => '',
				'required'    => false,
				'logo'        => takeout_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
				'group'       => $takeout_theme_required_plugins_groups['ecommerce'],
			),
			'woo-smart-quick-view'                  => array(
				'title'       => esc_html__( 'WPC Smart Quick View for WooCommerce', 'takeout' ),
				'description' => '',
				'required'    => false,
				'logo'        => takeout_get_file_url( 'plugins/woo-smart-quick-view/woo-smart-quick-view.png' ),
				'group'       => $takeout_theme_required_plugins_groups['ecommerce'],
			),
			'twenty20'                  => array(
				'title'       => esc_html__( 'Twenty20 Image Before-After', 'takeout' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => takeout_get_file_url( 'plugins/twenty20/twenty20.png' ),
				'group'       => $takeout_theme_required_plugins_groups['content'],
			),
			'essential-grid'             => array(
				'title'       => esc_html__( 'Essential Grid', 'takeout' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => 'essential-grid.png',
				'group'       => $takeout_theme_required_plugins_groups['content'],
			),
			'revslider'                  => array(
				'title'       => esc_html__( 'Revolution Slider', 'takeout' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => 'revslider.png',
				'group'       => $takeout_theme_required_plugins_groups['content'],
			),
			'sitepress-multilingual-cms' => array(
				'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'takeout' ),
				'description' => esc_html__( "Allows you to make your website multilingual", 'takeout' ),
				'required'    => false,
				'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'sitepress-multilingual-cms.png',
				'group'       => $takeout_theme_required_plugins_groups['content'],
			),
			'wp-gdpr-compliance'         => array(
				'title'       => esc_html__( 'Cookie Information', 'takeout' ),
				'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'takeout' ),
				'required'    => false,
				'install'     => false,
				'logo'        => 'wp-gdpr-compliance.png',
				'group'       => $takeout_theme_required_plugins_groups['other'],
			),
			'gdpr-framework'         => array(
				'title'       => esc_html__( 'The GDPR Framework', 'takeout' ),
				'description' => esc_html__( "Tools to help make your website GDPR-compliant. Fully documented, extendable and developer-friendly.", 'takeout' ),
				'required'    => false,
				'install'     => false,
				'logo'        => 'gdpr-framework.png',
				'group'       => $takeout_theme_required_plugins_groups['other'],
			),
			'trx_updater'                => array(
				'title'       => esc_html__( 'ThemeREX Updater', 'takeout' ),
				'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'takeout' ),
				'required'    => false,
				'logo'        => 'trx_updater.png',
				'group'       => $takeout_theme_required_plugins_groups['other'],
			),
			'sportspress'                  => array(
				'title'       => esc_html__( 'SportsPress', 'takeout' ),
				'description' => esc_html__( "Sports Club & League Manager.", 'takeout' ),
				'required'    => false,
				'logo'        => takeout_get_file_url( 'plugins/sportspress/sportspress.png' ),
				'group'       => $takeout_theme_required_plugins_groups['content'],
			),
		);

		if ( TAKEOUT_THEME_FREE ) {
			unset( $takeout_theme_required_plugins['js_composer'] );
			unset( $takeout_theme_required_plugins['booked'] );
			unset( $takeout_theme_required_plugins['quickcal'] );
			unset( $takeout_theme_required_plugins['the-events-calendar'] );
			unset( $takeout_theme_required_plugins['calculated-fields-form'] );
			unset( $takeout_theme_required_plugins['essential-grid'] );
			unset( $takeout_theme_required_plugins['revslider'] );
			unset( $takeout_theme_required_plugins['sitepress-multilingual-cms'] );
			unset( $takeout_theme_required_plugins['trx_updater'] );
			unset( $takeout_theme_required_plugins['trx_popup'] );
		}

		// Add plugins list to the global storage
		takeout_storage_set( 'required_plugins', $takeout_theme_required_plugins );
	}
}
