<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0
 */

$takeout_template = apply_filters( 'takeout_filter_get_template_part', takeout_blog_archive_get_template() );

if ( ! empty( $takeout_template ) && 'index' != $takeout_template ) {

	get_template_part( $takeout_template );

} else {

	takeout_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$takeout_stickies   = is_home()
								|| ( in_array( takeout_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) takeout_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$takeout_post_type  = takeout_get_theme_option( 'post_type' );
		$takeout_args       = array(
								'blog_style'     => takeout_get_theme_option( 'blog_style' ),
								'post_type'      => $takeout_post_type,
								'taxonomy'       => takeout_get_post_type_taxonomy( $takeout_post_type ),
								'parent_cat'     => takeout_get_theme_option( 'parent_cat' ),
								'posts_per_page' => takeout_get_theme_option( 'posts_per_page' ),
								'sticky'         => takeout_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $takeout_stickies )
															&& count( $takeout_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		takeout_blog_archive_start();

		do_action( 'takeout_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'takeout_action_before_page_author' );
			get_template_part( apply_filters( 'takeout_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'takeout_action_after_page_author' );
		}

		if ( takeout_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'takeout_action_before_page_filters' );
			takeout_show_filters( $takeout_args );
			do_action( 'takeout_action_after_page_filters' );
		} else {
			do_action( 'takeout_action_before_page_posts' );
			takeout_show_posts( array_merge( $takeout_args, array( 'cat' => $takeout_args['parent_cat'] ) ) );
			do_action( 'takeout_action_after_page_posts' );
		}

		do_action( 'takeout_action_blog_archive_end' );

		takeout_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'takeout_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'takeout_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
