<div class="front_page_section front_page_section_testimonials<?php
	$takeout_scheme = takeout_get_theme_option( 'front_page_testimonials_scheme' );
	if ( ! empty( $takeout_scheme ) && ! takeout_is_inherit( $takeout_scheme ) ) {
		echo ' scheme_' . esc_attr( $takeout_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( takeout_get_theme_option( 'front_page_testimonials_paddings' ) );
	if ( takeout_get_theme_option( 'front_page_testimonials_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$takeout_css      = '';
		$takeout_bg_image = takeout_get_theme_option( 'front_page_testimonials_bg_image' );
		if ( ! empty( $takeout_bg_image ) ) {
			$takeout_css .= 'background-image: url(' . esc_url( takeout_get_attachment_url( $takeout_bg_image ) ) . ');';
		}
		if ( ! empty( $takeout_css ) ) {
			echo ' style="' . esc_attr( $takeout_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$takeout_anchor_icon = takeout_get_theme_option( 'front_page_testimonials_anchor_icon' );
	$takeout_anchor_text = takeout_get_theme_option( 'front_page_testimonials_anchor_text' );
if ( ( ! empty( $takeout_anchor_icon ) || ! empty( $takeout_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_testimonials"'
									. ( ! empty( $takeout_anchor_icon ) ? ' icon="' . esc_attr( $takeout_anchor_icon ) . '"' : '' )
									. ( ! empty( $takeout_anchor_text ) ? ' title="' . esc_attr( $takeout_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_testimonials_inner
	<?php
	if ( takeout_get_theme_option( 'front_page_testimonials_fullheight' ) ) {
		echo ' takeout-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$takeout_css      = '';
			$takeout_bg_mask  = takeout_get_theme_option( 'front_page_testimonials_bg_mask' );
			$takeout_bg_color_type = takeout_get_theme_option( 'front_page_testimonials_bg_color_type' );
			if ( 'custom' == $takeout_bg_color_type ) {
				$takeout_bg_color = takeout_get_theme_option( 'front_page_testimonials_bg_color' );
			} elseif ( 'scheme_bg_color' == $takeout_bg_color_type ) {
				$takeout_bg_color = takeout_get_scheme_color( 'bg_color', $takeout_scheme );
			} else {
				$takeout_bg_color = '';
			}
			if ( ! empty( $takeout_bg_color ) && $takeout_bg_mask > 0 ) {
				$takeout_css .= 'background-color: ' . esc_attr(
					1 == $takeout_bg_mask ? $takeout_bg_color : takeout_hex2rgba( $takeout_bg_color, $takeout_bg_mask )
				) . ';';
			}
			if ( ! empty( $takeout_css ) ) {
				echo ' style="' . esc_attr( $takeout_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_testimonials_content_wrap content_wrap">
			<?php
			// Caption
			$takeout_caption = takeout_get_theme_option( 'front_page_testimonials_caption' );
			if ( ! empty( $takeout_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_testimonials_caption front_page_block_<?php echo ! empty( $takeout_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $takeout_caption, 'takeout_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$takeout_description = takeout_get_theme_option( 'front_page_testimonials_description' );
			if ( ! empty( $takeout_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_testimonials_description front_page_block_<?php echo ! empty( $takeout_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $takeout_description ), 'takeout_kses_content' ); ?></div>
				<?php
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_testimonials_output">
				<?php
				if ( is_active_sidebar( 'front_page_testimonials_widgets' ) ) {
					dynamic_sidebar( 'front_page_testimonials_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! takeout_exists_trx_addons() ) {
						takeout_customizer_need_trx_addons_message();
					} else {
						takeout_customizer_need_widgets_message( 'front_page_testimonials_caption', 'ThemeREX Addons - Testimonials' );
					}
				}
				?>
			</div>
		</div>
	</div>
</div>
