// calculator.js
jQuery(document).ready(function($) {
    // Add new appliance row
    $('#add-appliance').click(function() {
        var row = $('.appliance-row:first').clone();
        row.find('select, input').val('');
        row.appendTo('#appliances');
    });

    // Remove row
    $(document).on('click', '.remove-row', function() {
        if ($('.appliance-row').length > 1) {
            $(this).closest('.appliance-row').remove();
        }
    });

    // Calculate
    $('#calculate').click(function() {
        var total_load = 0;
        $('.appliance-row').each(function() {
            var appliance = $(this).find('.appliance-select').val();
            if (appliance) {
                var parts = appliance.split('|');
                var watts = parseInt(parts[1]);
                var qty = parseInt($(this).find('.quantity').val()) || 1;
                total_load += watts * qty;
            }
        });

        var backup_hours = parseInt($('#backup-time').val());

        // Simple calculations (adjust formulas as needed)
        var required_energy = total_load * backup_hours; // Wh
        var rec_inverter = Math.ceil((total_load * 1.2) / 1000) * 1000; // VA, with 20% safety, rounded up to nearest 1000
        var rec_battery = Math.ceil((required_energy / 12) / 0.5); // Ah at 12V, 50% DOD for lead-acid

        $('#total-load').text(total_load);
        $('#required-energy').text(required_energy);
        $('#rec-inverter').text(rec_inverter);
        $('#rec-battery').text(rec_battery);

        // AJAX to get product recommendations
        $.ajax({
            url: '/wp-admin/admin-ajax.php', // WordPress AJAX URL
            type: 'POST',
            data: {
                action: 'get_recommendations',
                total_load: total_load,
                required_energy: required_energy,
                rec_inverter: rec_inverter,
                rec_battery: rec_battery
            },
            success: function(response) {
                if (response.success) {
                    var html = '';
                    if (response.data.inverters) {
                        html += '<h4>Inverters</h4><ul>';
                        $.each(response.data.inverters, function(i, prod) {
                            html += '<li><a href="' + prod.link + '">' + prod.name + '</a> - ' + prod.price + '</li>';
                        });
                        html += '</ul>';
                    }
                    if (response.data.batteries) {
                        html += '<h4>Batteries</h4><ul>';
                        $.each(response.data.batteries, function(i, prod) {
                            html += '<li><a href="' + prod.link + '">' + prod.name + '</a> - ' + prod.price + '</li>';
                        });
                        html += '</ul>';
                    }
                    $('#product-recommendations').html(html);
                }
            }
        });

        $('#results').show();
    });
});