<?php

/**
 * Views class for Shortcode generator options.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package chat-whatsapp-pro
 * @subpackage chat-whatsapp-pro/src/Admin/Views/ChatWhatsappProBackup
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\ChatWhatsappPro\Admin\Views;

use ThemeAtelier\ChatWhatsappPro\Admin\Framework\Classes\CHAT_WHATSAPP_PRO;

class ChatWhatsappProBackup
{

    /**
     * Create Option fields for the setting options.
     *
     * @param string $prefix Option setting key prefix.
     * @return void
     */
    public static function options($prefix)
    {
        //
        // Field: backup
        //
        CHAT_WHATSAPP_PRO::createSection($prefix, array(
            'title'       => esc_html__('BACKUP', 'chat-whatsapp-pro'),
            'icon'        => 'icofont-shield',
            'description' => esc_html__('Export or import to use same settings in different websites.', 'chat-whatsapp-pro'),
            'fields'      => array(
                array(
                    'type' => 'backup',
                ),
            )
        ));
    }
}
