<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access directly.
/**
 *
 * Field: background
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
use ThemeAtelier\ChatWhatsappPro\Admin\Framework\Classes\CHAT_WHATSAPP_PRO;

if ( ! class_exists( 'CHAT_WHATSAPP_PRO_Field_background' ) ) {
  class CHAT_WHATSAPP_PRO_Field_background extends CHAT_WHATSAPP_PRO_Fields {

    public function __construct( $field, $value = '', $unique = '', $where = '', $parent = '' ) {
      parent::__construct( $field, $value, $unique, $where, $parent );
    }

    public function render() {

      $args                             = wp_parse_args( $this->field, array(
        'background_color'              => true,
        'background_image'              => true,
        'background_position'           => true,
        'background_repeat'             => true,
        'background_attachment'         => true,
        'background_size'               => true,
        'background_origin'             => false,
        'background_clip'               => false,
        'background_blend_mode'         => false,
        'background_gradient'           => false,
        'background_gradient_color'     => true,
        'background_gradient_direction' => true,
        'background_image_preview'      => true,
        'background_auto_attributes'    => false,
        'compact'                       => false,
        'background_image_library'      => 'image',
        'background_image_placeholder'  => esc_html__( 'Not selected', 'chat-whatsapp-pro' ),
      ) );

      if ( $args['compact'] ) {
        $args['background_color']           = false;
        $args['background_auto_attributes'] = true;
      }

      $default_value                    = array(
        'background-color'              => '',
        'background-image'              => '',
        'background-position'           => '',
        'background-repeat'             => '',
        'background-attachment'         => '',
        'background-size'               => '',
        'background-origin'             => '',
        'background-clip'               => '',
        'background-blend-mode'         => '',
        'background-gradient-color'     => '',
        'background-gradient-direction' => '',
      );

      $default_value = ( ! empty( $this->field['default'] ) ) ? wp_parse_args( $this->field['default'], $default_value ) : $default_value;

      $this->value = wp_parse_args( $this->value, $default_value );

      echo wp_kses_post($this->field_before());

      echo '<div class="chat-whatsapp--background-colors">';

      //
      // Background Color
      if ( ! empty( $args['background_color'] ) ) {

        echo '<div class="chat-whatsapp--color">';

        echo ( ! empty( $args['background_gradient'] ) ) ? '<div class="chat-whatsapp--title">'. esc_html__( 'From', 'chat-whatsapp-pro' ) .'</div>' : '';

        CHAT_WHATSAPP_PRO::field( array(
          'id'      => 'background-color',
          'type'    => 'color',
          'default' => $default_value['background-color'],
        ), $this->value['background-color'], $this->field_name(), 'field/background' );

        echo '</div>';

      }

      //
      // Background Gradient Color
      if ( ! empty( $args['background_gradient_color'] ) && ! empty( $args['background_gradient'] ) ) {

        echo '<div class="chat-whatsapp--color">';

        echo ( ! empty( $args['background_gradient'] ) ) ? '<div class="chat-whatsapp--title">'. esc_html__( 'To', 'chat-whatsapp-pro' ) .'</div>' : '';

        CHAT_WHATSAPP_PRO::field( array(
          'id'      => 'background-gradient-color',
          'type'    => 'color',
          'default' => $default_value['background-gradient-color'],
        ), $this->value['background-gradient-color'], $this->field_name(), 'field/background' );

        echo '</div>';

      }

      //
      // Background Gradient Direction
      if ( ! empty( $args['background_gradient_direction'] ) && ! empty( $args['background_gradient'] ) ) {

        echo '<div class="chat-whatsapp--color">';

        echo ( ! empty( $args['background_gradient'] ) ) ? '<div class="chat-whatsapp---title">'. esc_html__( 'Direction', 'chat-whatsapp-pro' ) .'</div>' : '';

        CHAT_WHATSAPP_PRO::field( array(
          'id'          => 'background-gradient-direction',
          'type'        => 'select',
          'options'     => array(
            ''          => esc_html__( 'Gradient Direction', 'chat-whatsapp-pro' ),
            'to bottom' => esc_html__( '&#8659; top to bottom', 'chat-whatsapp-pro' ),
            'to right'  => esc_html__( '&#8658; left to right', 'chat-whatsapp-pro' ),
            '135deg'    => esc_html__( '&#8664; corner top to right', 'chat-whatsapp-pro' ),
            '-135deg'   => esc_html__( '&#8665; corner top to left', 'chat-whatsapp-pro' ),
          ),
        ), $this->value['background-gradient-direction'], $this->field_name(), 'field/background' );

        echo '</div>';

      }

      echo '</div>';

      //
      // Background Image
      if ( ! empty( $args['background_image'] ) ) {

        echo '<div class="chat-whatsapp--background-image">';

        CHAT_WHATSAPP_PRO::field( array(
          'id'          => 'background-image',
          'type'        => 'media',
          'class'       => 'chat-whatsapp-assign-field-background',
          'library'     => $args['background_image_library'],
          'preview'     => $args['background_image_preview'],
          'placeholder' => $args['background_image_placeholder'],
          'attributes'  => array( 'data-depend-id' => $this->field['id'] ),
        ), $this->value['background-image'], $this->field_name(), 'field/background' );

        echo '</div>';

      }

      $auto_class   = ( ! empty( $args['background_auto_attributes'] ) ) ? ' chat-whatsapp--auto-attributes' : '';
      $hidden_class = ( ! empty( $args['background_auto_attributes'] ) && empty( $this->value['background-image']['url'] ) ) ? ' chat-whatsapp--attributes-hidden' : '';

      echo '<div class="chat-whatsapp--background-attributes'. esc_attr( $auto_class . $hidden_class ) .'">';

      //
      // Background Position
      if ( ! empty( $args['background_position'] ) ) {

        CHAT_WHATSAPP_PRO::field( array(
          'id'              => 'background-position',
          'type'            => 'select',
          'options'         => array(
            ''              => esc_html__( 'Background Position', 'chat-whatsapp-pro' ),
            'left top'      => esc_html__( 'Left Top', 'chat-whatsapp-pro' ),
            'left center'   => esc_html__( 'Left Center', 'chat-whatsapp-pro' ),
            'left bottom'   => esc_html__( 'Left Bottom', 'chat-whatsapp-pro' ),
            'center top'    => esc_html__( 'Center Top', 'chat-whatsapp-pro' ),
            'center center' => esc_html__( 'Center Center', 'chat-whatsapp-pro' ),
            'center bottom' => esc_html__( 'Center Bottom', 'chat-whatsapp-pro' ),
            'right top'     => esc_html__( 'Right Top', 'chat-whatsapp-pro' ),
            'right center'  => esc_html__( 'Right Center', 'chat-whatsapp-pro' ),
            'right bottom'  => esc_html__( 'Right Bottom', 'chat-whatsapp-pro' ),
          ),
        ), $this->value['background-position'], $this->field_name(), 'field/background' );

      }

      //
      // Background Repeat
      if ( ! empty( $args['background_repeat'] ) ) {

        CHAT_WHATSAPP_PRO::field( array(
          'id'          => 'background-repeat',
          'type'        => 'select',
          'options'     => array(
            ''          => esc_html__( 'Background Repeat', 'chat-whatsapp-pro' ),
            'repeat'    => esc_html__( 'Repeat', 'chat-whatsapp-pro' ),
            'no-repeat' => esc_html__( 'No Repeat', 'chat-whatsapp-pro' ),
            'repeat-x'  => esc_html__( 'Repeat Horizontally', 'chat-whatsapp-pro' ),
            'repeat-y'  => esc_html__( 'Repeat Vertically', 'chat-whatsapp-pro' ),
          ),
        ), $this->value['background-repeat'], $this->field_name(), 'field/background' );

      }

      //
      // Background Attachment
      if ( ! empty( $args['background_attachment'] ) ) {

        CHAT_WHATSAPP_PRO::field( array(
          'id'       => 'background-attachment',
          'type'     => 'select',
          'options'  => array(
            ''       => esc_html__( 'Background Attachment', 'chat-whatsapp-pro' ),
            'scroll' => esc_html__( 'Scroll', 'chat-whatsapp-pro' ),
            'fixed'  => esc_html__( 'Fixed', 'chat-whatsapp-pro' ),
          ),
        ), $this->value['background-attachment'], $this->field_name(), 'field/background' );

      }

      //
      // Background Size
      if ( ! empty( $args['background_size'] ) ) {

        CHAT_WHATSAPP_PRO::field( array(
          'id'        => 'background-size',
          'type'      => 'select',
          'options'   => array(
            ''        => esc_html__( 'Background Size', 'chat-whatsapp-pro' ),
            'cover'   => esc_html__( 'Cover', 'chat-whatsapp-pro' ),
            'contain' => esc_html__( 'Contain', 'chat-whatsapp-pro' ),
            'auto'    => esc_html__( 'Auto', 'chat-whatsapp-pro' ),
          ),
        ), $this->value['background-size'], $this->field_name(), 'field/background' );

      }

      //
      // Background Origin
      if ( ! empty( $args['background_origin'] ) ) {

        CHAT_WHATSAPP_PRO::field( array(
          'id'            => 'background-origin',
          'type'          => 'select',
          'options'       => array(
            ''            => esc_html__( 'Background Origin', 'chat-whatsapp-pro' ),
            'padding-box' => esc_html__( 'Padding Box', 'chat-whatsapp-pro' ),
            'border-box'  => esc_html__( 'Border Box', 'chat-whatsapp-pro' ),
            'content-box' => esc_html__( 'Content Box', 'chat-whatsapp-pro' ),
          ),
        ), $this->value['background-origin'], $this->field_name(), 'field/background' );

      }

      //
      // Background Clip
      if ( ! empty( $args['background_clip'] ) ) {

        CHAT_WHATSAPP_PRO::field( array(
          'id'            => 'background-clip',
          'type'          => 'select',
          'options'       => array(
            ''            => esc_html__( 'Background Clip', 'chat-whatsapp-pro' ),
            'border-box'  => esc_html__( 'Border Box', 'chat-whatsapp-pro' ),
            'padding-box' => esc_html__( 'Padding Box', 'chat-whatsapp-pro' ),
            'content-box' => esc_html__( 'Content Box', 'chat-whatsapp-pro' ),
          ),
        ), $this->value['background-clip'], $this->field_name(), 'field/background' );

      }

      //
      // Background Blend Mode
      if ( ! empty( $args['background_blend_mode'] ) ) {

        CHAT_WHATSAPP_PRO::field( array(
          'id'            => 'background-blend-mode',
          'type'          => 'select',
          'options'       => array(
            ''            => esc_html__( 'Background Blend Mode', 'chat-whatsapp-pro' ),
            'normal'      => esc_html__( 'Normal', 'chat-whatsapp-pro' ),
            'multiply'    => esc_html__( 'Multiply', 'chat-whatsapp-pro' ),
            'screen'      => esc_html__( 'Screen', 'chat-whatsapp-pro' ),
            'overlay'     => esc_html__( 'Overlay', 'chat-whatsapp-pro' ),
            'darken'      => esc_html__( 'Darken', 'chat-whatsapp-pro' ),
            'lighten'     => esc_html__( 'Lighten', 'chat-whatsapp-pro' ),
            'color-dodge' => esc_html__( 'Color Dodge', 'chat-whatsapp-pro' ),
            'saturation'  => esc_html__( 'Saturation', 'chat-whatsapp-pro' ),
            'color'       => esc_html__( 'Color', 'chat-whatsapp-pro' ),
            'luminosity'  => esc_html__( 'Luminosity', 'chat-whatsapp-pro' ),
          ),
        ), $this->value['background-blend-mode'], $this->field_name(), 'field/background' );

      }

      echo '</div>';

      echo wp_kses_post($this->field_after());

    }

    public function output() {

      $output    = '';
      $bg_image  = array();
      $important = ( ! empty( $this->field['output_important'] ) ) ? '!important' : '';
      $element   = ( is_array( $this->field['output'] ) ) ? join( ',', $this->field['output'] ) : $this->field['output'];

      // Background image and gradient
      $background_color        = ( ! empty( $this->value['background-color']              ) ) ? $this->value['background-color']              : '';
      $background_gd_color     = ( ! empty( $this->value['background-gradient-color']     ) ) ? $this->value['background-gradient-color']     : '';
      $background_gd_direction = ( ! empty( $this->value['background-gradient-direction'] ) ) ? $this->value['background-gradient-direction'] : '';
      $background_image        = ( ! empty( $this->value['background-image']['url']       ) ) ? $this->value['background-image']['url']       : '';


      if ( $background_color && $background_gd_color ) {
        $gd_direction   = ( $background_gd_direction ) ? $background_gd_direction .',' : '';
        $bg_image[] = 'linear-gradient('. $gd_direction . $background_color .','. $background_gd_color .')';
        unset( $this->value['background-color'] );
      }

      if ( $background_image ) {
        $bg_image[] = 'url('. $background_image .')';
      }

      if ( ! empty( $bg_image ) ) {
        $output .= 'background-image:'. implode( ',', $bg_image ) . $important .';';
      }

      // Common background properties
      $properties = array( 'color', 'position', 'repeat', 'attachment', 'size', 'origin', 'clip', 'blend-mode' );

      foreach ( $properties as $property ) {
        $property = 'background-'. $property;
        if ( ! empty( $this->value[$property] ) ) {
          $output .= $property .':'. $this->value[$property] . $important .';';
        }
      }

      if ( $output ) {
        $output = $element .'{'. $output .'}';
      }

      $this->parent->output_css .= $output;

      return $output;

    }

  }
}
