<?php

/**
 * The admin-facing functionality of the plugin.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package chat-whatsapp-pro
 * @subpackage chat-whatsapp-pro/src/Admin
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\ChatWhatsappPro\Admin;

use ThemeAtelier\ChatWhatsappPro\Admin\Views\ChatWhatsappProOptions;

/**
 * The admin class
 */
class Admin
{
    /**
     * The slug of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_slug   The slug of this plugin.
     */
    private $plugin_slug;

    /**
     * The min of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $min   The slug of this plugin.
     */
    private $min;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * The class constructor.
     *
     * @param string $plugin_slug The slug of the plugin.
     * @param string $version Current version of the plugin.
     */
    function __construct($plugin_slug, $version)
    {
        $this->plugin_slug = $plugin_slug;
        $this->version     = $version;
        $this->min         = defined('WP_DEBUG') && WP_DEBUG ? '' : '.min';
        ChatWhatsappProOptions::options('cwp_option');
        add_action('admin_menu', array($this, 'add_plugin_page'));
    }

    /**
     * Register the stylesheets for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public static function enqueue_scripts($hook)
    {
        wp_enqueue_style('chat-whatsapp-pro-admin-style');
    }

    public function add_plugin_page()
    {
        // This page will be under "Settings"
        add_menu_page(
            esc_html__('Whatsapp Chat', 'chat-whatsapp-pro'),
            esc_html__('Whatsapp Chat', 'chat-whatsapp-pro'),
            'manage_options',
            'chat-whatsapp-pro',
            array($this, 'chat_help_settings'),
            'dashicons-whatsapp',
            6
        );

    }

    /**
     * Options page callback
     */
    public function chat_help_settings() {}
}
